/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import jclass.table3.JCPrintPage;
import jclass.table3.JCPrintTable;

public class JCPrintPreview
extends Frame
implements WindowListener,
ActionListener {
    Button first_button;
    Button prev_button;
    Button next_button;
    Button last_button;
    Button print_button;
    Button printall_button;
    Button close_button;
    ScrollPane pane;
    JCPrintTable table;
    JCPrintPage print_page;
    Label status;
    int current_page;
    int num_pages;
    int width;
    int height;
    PrintJob job;

    public JCPrintPreview(String string, JCPrintTable jCPrintTable) {
        super(string);
        Cloneable cloneable;
        this.table = jCPrintTable;
        try {
            cloneable = new Properties();
            this.job = this.getToolkit().getPrintJob(this, "Table3", (Properties)cloneable);
        }
        catch (Exception exception) {
            System.out.println("PrintJob error: " + exception.getMessage());
            return;
        }
        if (this.job == null) {
            return;
        }
        cloneable = this.job.getPageDimension();
        if (((Dimension)cloneable).width == 0 || ((Dimension)cloneable).height == 0) {
            ((Dimension)cloneable).width = 612;
            ((Dimension)cloneable).height = 792;
        }
        this.width = ((Dimension)cloneable).width;
        this.height = ((Dimension)cloneable).height;
        jCPrintTable.setPageDimensions(((Dimension)cloneable).width, ((Dimension)cloneable).height);
        this.num_pages = jCPrintTable.getNumPages();
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(Color.lightGray);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 1, 1));
        this.first_button = new Button("First");
        panel.add(this.first_button);
        this.first_button.addActionListener(this);
        this.prev_button = new Button("Previous");
        panel.add(this.prev_button);
        this.prev_button.addActionListener(this);
        this.next_button = new Button("Next");
        panel.add(this.next_button);
        this.next_button.addActionListener(this);
        this.last_button = new Button("Last");
        panel.add(this.last_button);
        this.last_button.addActionListener(this);
        this.print_button = new Button("Print");
        panel.add(this.print_button);
        this.print_button.addActionListener(this);
        this.printall_button = new Button("PrintAll");
        panel.add(this.printall_button);
        this.printall_button.addActionListener(this);
        this.close_button = new Button("Close");
        panel.add(this.close_button);
        this.close_button.addActionListener(this);
        this.add((Component)panel, "North");
        Dimension dimension = new Dimension((int)((double)this.width * 1.05), (int)((double)this.height * 1.05));
        this.pane = new ScrollPane(0);
        this.pane.setSize(dimension);
        this.print_page = new JCPrintPage(dimension);
        this.pane.add(this.print_page);
        this.print_page.setSize(this.print_page.getPreferredSize());
        this.add((Component)this.pane, "Center");
        this.status = new Label("", 0);
        this.add((Component)this.status, "South");
        this.addWindowListener(this);
        ((Component)this).setSize(600, 500);
        ((Component)this).setVisible(true);
    }

    public void showPage(int n) {
        if (this.job == null) {
            return;
        }
        this.current_page = n;
        Image image = this.createImage(this.width, this.height);
        Graphics graphics = image.getGraphics();
        this.table.paintPage(graphics, n);
        this.print_page.setImage(image);
        graphics.dispose();
        this.status.setText("Page " + (this.current_page + 1) + " of " + this.num_pages + ".");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("First")) {
            this.showPage(0);
            return;
        }
        if (actionEvent.getActionCommand().equals("Previous")) {
            if (this.current_page > 0) {
                this.showPage(this.current_page - 1);
                return;
            }
        } else if (actionEvent.getActionCommand().equals("Next")) {
            if (this.current_page + 1 < this.num_pages) {
                this.showPage(this.current_page + 1);
                return;
            }
        } else {
            if (actionEvent.getActionCommand().equals("Last")) {
                this.showPage(this.num_pages - 1);
                return;
            }
            if (actionEvent.getActionCommand().equals("Print")) {
                if (this.job != null) {
                    Graphics graphics = this.job.getGraphics();
                    this.table.paintPage(graphics, this.current_page);
                    graphics.dispose();
                    return;
                }
            } else if (actionEvent.getActionCommand().equals("PrintAll")) {
                if (this.job != null) {
                    int n = 0;
                    while (n < this.num_pages) {
                        Graphics graphics = this.job.getGraphics();
                        this.table.paintPage(graphics, n);
                        graphics.dispose();
                        ++n;
                    }
                    return;
                }
            } else if (actionEvent.getActionCommand().equals("Close")) {
                if (this.job != null) {
                    this.job.end();
                }
                ((Component)this).setVisible(false);
                this.dispose();
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

